/*
 * Decompiled with CFR 0.152.
 */
package com.skloch.game.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.skloch.game.HustleGame;
import com.skloch.game.scoring.Leaderboard;

public abstract class LeaderboardScreen
implements Screen {
    protected HustleGame game;
    protected Stage leaderboardStage;
    protected OrthographicCamera camera;
    protected Viewport viewport;

    public LeaderboardScreen(HustleGame game) {
        this.game = game;
        this.leaderboardStage = new Stage(new FitViewport(game.width, game.height));
        Gdx.input.setInputProcessor(this.leaderboardStage);
        this.camera = new OrthographicCamera();
        this.viewport = new FitViewport(game.width, (float)game.height, this.camera);
        this.camera.setToOrtho(false, game.width, game.height);
        Window leaderboardMenu = new Window("", game.skin);
        this.leaderboardStage.addActor(leaderboardMenu);
        leaderboardMenu.setModal(true);
        Table leaderboardTable = new Table();
        leaderboardMenu.add(leaderboardTable).prefHeight(600.0f);
        Label title = new Label("Leaderboard", game.skin, "button");
        leaderboardTable.add(title).padTop(10.0f);
        leaderboardTable.row();
        Table scrollTable = new Table();
        ScrollPane scrollWindow = new ScrollPane((Actor)scrollTable, game.skin);
        scrollWindow.setFadeScrollBars(false);
        leaderboardTable.add(scrollWindow).padTop(20.0f).height(350.0f);
        leaderboardTable.row();
        Label text = new Label(Leaderboard.getInstance().getFormattedTopScores(), game.skin, "interaction");
        text.setWrap(true);
        scrollTable.add(text).width(520.0f).padLeft(15.0f);
        TextButton exitButton = new TextButton(this.getExitButtonText(), game.skin);
        leaderboardTable.add(exitButton).bottom().width(300.0f).padTop(10.0f);
        leaderboardMenu.pack();
        leaderboardMenu.setSize(600.0f, 600.0f);
        leaderboardMenu.setX(this.viewport.getWorldWidth() / 2.0f - leaderboardMenu.getWidth() / 2.0f);
        leaderboardMenu.setY(this.viewport.getWorldHeight() / 2.0f - leaderboardMenu.getHeight() / 2.0f);
        exitButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                LeaderboardScreen.this.onExitPressed();
            }
        });
    }

    protected abstract void onExitPressed();

    protected abstract String getExitButtonText();

    @Override
    public void render(float delta) {
        ScreenUtils.clear(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.game.blueBackground.draw();
        this.leaderboardStage.act(delta);
        this.leaderboardStage.draw();
        this.camera.update();
    }

    @Override
    public void resize(int width, int height) {
        this.leaderboardStage.getViewport().update(width, height);
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }
}

